function write_nxs(object,filename,entry)
% write_nxs(object_in,'file.nxs','entry')
% object_in is the object to be written to the file
% 'entry' optionally writes entry to top level directory of object in nexus
% file, the default entry name will be 'object' if object_in is of type IXTobject
% ie. if it is of type IXTrunfile, the entry will be 'runfile'
if ischar(filename) && isobject(object)
    disp(['Creating file: ',filename]);
    fio=open(IXTfileio,translate_write(filename),4);
    if nargin > 2 && ischar(entry)
        write(object,fio,entry);
        fio=close(fio);
    else
        write(object,fio,'');
        fio=close(fio);
    end
else
    disp('invalid filename or object input');
    return
end

