function  cellout = pre_parse(method,varargin)
% a function that creates a cell array that can be sent to homer or
% diagnose, it removes the keyword of an argument that is sent as an empty
% vector or string and in that way allows the passing of homer arguments to
% agree with toby's parse arguments rountine that will define an argument
% keyword as present if it passed as empty

%method =1 --> Diagnose
%method =2 --> Homer

if isempty(varargin)
    disp('No data error')
    return
end
if isempty(method)||method~=1 & method~=2
    disp('no method selected')
end

if method == 2 % run for homer
    %inlist is the input argument structure for Homer (less the data object!)
    inlist = struct(... %homer argument names and default values
        'period',int32(1),...
        'ei',[],...
        'fixei',[],...
        'background',[], ...
        'det_map','', ...
        'det_mask','', ...
        'mon_map','',...
        'mon_mask','',...
        'm_rebin',[],...
        'd_int',[],...
        'd_rebin',[],...
        'det_units','',...
        'mon_units','',...
        'normalisation',[],...
        'range',[],...
        'scale',1.0,...
        'nchunk',default_homer_nchunk,... % this seems to be the fastest of them all
        'solid',[],...
        'corr',0,...
        'abs',0,...
        'mass',[],...
        'RMM',[]);

    [par,argout,present] = parse_arguments(varargin,inlist,{'corr'});
    if argout.corr==0;
        argout.corr=[];
    end
    if argout.abs==0;
        argout.abs=[];
    end
    
    aa=struct2cell(argout);
    bb=fieldnames(argout);
    length(aa);
    length(bb);
    
    if length(aa)==length(bb);
        cellout=[];
        for i=1:length(aa);
            if isempty(aa{i});
                continue
            else
                cellout=cat(1,cellout,bb{i});
                cellout=cat(1,cellout,aa(i));
            end
        end
    end
end
if method ==1 %run for diagnose not actually needed for the gui
    inlist = struct(... % argument names and default values
    'tiny',1e-10,...
    'huge',1e10,...
    'bmin',[],...
    'bmax',[],...
    's_zero',false,...
    's_out_lo',[],...
    's_out_hi',[], ...
    'sv_lo',[], ...
    'sv_hi',[], ...
    'sv_sig',[],...
    'v_zero',true,...
    'v_out_lo',[],...
    'v_out_hi',[], ...
    'vv_lo',[], ...
    'vv_hi',[], ...
    'vv_sig',[],...
    'r',[],...
    'r_sig',[],...
    'rfile_entry','',...
    'rf_v1_entry','',...
    'rf_v2',[],...
    'rf_v2_entry','',...  
    'bank',[],...
    'bank_entry','',...
    'hardmask',[],...
    'hmask_entry','',...
    'out_nex','',...
    'out_nex_entry','',...
    'out_asc','',...
    'summary',true,...
    'messages',false);

    flags = {'s_zero','v_zero','summary','messages'};


    [par,argout,present] = parse_arguments(varargin,inlist,flags);
    
    if argout.s_zero==0;
        argout.s_zero=[];
    end
    if argout.v_zero==0;
        argout.v_zero=[];
    end
    if argout.summary==0;
        argout.summmary=[];
    end
    if argout.messages==0;
        argout.messages=[];
    end
    
    aa=struct2cell(argout);
    bb=fieldnames(argout);
    length(aa);
    length(bb);
    
    if length(aa)==length(bb);
        cellout=[];
        for i=1:length(aa);
            if isempty(aa{i});
                continue
            else
                cellout=cat(1,cellout,bb{i});
                cellout=cat(1,cellout,aa(i));
            end
        end
    end
end

end




% check output with parse argumanets   
%[par,argout,present] = parse_arguments(cellout,inlist,{'corr'})

    

