function [fig_out, axes_out, plot_out] = pmoc(w,varargin)
%-----help for gtk line overplot command pl--------------------------------
%function syntax: PMOC(1ddataset_object,[property_name,property_value])
% purpose: plot a line over the current plot, regardless of it's current
% type
% input: 1d dataset object, property name and value
% output: none
% example: PMOC(w)
% PMOC(w,'color','red')
%--------------------------------------------------------------------------


% Dean Whittaker 2008
[IXG_ST_ERROR, IXG_ST_STDVALUES] = ixf_global_var('libisis_graphics','get','IXG_ST_ERROR','IXG_ST_STDVALUES');

%check args
if ( nargin < 1 )
    ixf_display_error(IXG_ST_ERROR.wrong_arg);
end
%check my figure
currflag = ixf_checkinit(IXG_ST_STDVALUES.currentfigure);
if (currflag == IXG_ST_STDVALUES.false)
    ixf_display_error(IXG_ST_ERROR.no_figure);
end

[name tag] = ixf_get_name_tag(gcf);

[figureHandle_, axesHandle_, plotHandle_] = pm(w, 'name', name, 'tag', tag, varargin{:});

if nargout > 0
    fig_out = figureHandle_;
    axes_out = axesHandle_;
    plot_out = plotHandle_;
end