function abs=monovan_abs(rf_v,varargin)
arglist = struct(... % argument names and default values
    'zero',true,...
    'tiny',1e-10,...
    'huge',1e10,...
    'out_lo',0.01,...
    'out_hi',100, ...
    'v_lo',0.8, ...
    'v_hi',1.2, ...
    'v_sig',3);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% parsing of input arguments
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
flags = {'zero'};
[par,argout] = parse_arguments(varargin,arglist,flags);
%%%%
median=abs_calc(rf_v,argout.zero,argout.tiny,argout.huge,argout.out_lo,argout.out_hi,argout.v_lo,argout.v_hi,argout.v_sig);
ei=geteival(rf_v);
sigma_inc=van_incoh(ei);
abs=median/sigma_inc;
out=sprintf('Absolute Units Correction = %0.5g\n',abs);
disp(out);