function dataset_2d = IXTdataset_2d( varargin )
%  IXTdataset_2d(IXTbase, 'title', [signal], [error], IXTaxis,
%  [x], IXTaxis, [x_distribution],
%  [y], IXTaxis, [y_distribution])
% 
%  Creates an IXTdataset_2d object with the following elements:
%
%   IXTbase             IXTbase
% 	title				char			Title of dataset for plotting purposes
% 	signal				real    		Signal
% 	error				real    		Standard error
% 	s_axis				IXTaxis			S axis object containing caption and units codes
% 	x					real        	values of bin boundaries along x-axis(if histogram data)
% 						real            values of data point positions along x-axis(if point data)
% 	x_axis				IXTaxis			x axis object containing caption and units codes
% 	x_distribution      logical         x-data distribution data flag
% 	y					real        	values of bin boundaries along y-axis(if histogram data)
% 						real            values of data point positions along y-axis(if point data)
% 	y_axis				IXTaxis			y axis object containing caption and units codes
% 	y_distribution      logical         y-data distribution data flag

% core object
dataset_2d.base = IXTbase;
dataset_2d.title=[' '];
dataset_2d.signal=[0];
dataset_2d.error=[0];
dataset_2d.s_axis=IXTaxis;
dataset_2d.x=[0];
dataset_2d.x_axis=IXTaxis;
dataset_2d.x_distribution=false;
dataset_2d.y=[0];
dataset_2d.y_axis=IXTaxis;
dataset_2d.y_distribution=false;
dataset_2d = class(dataset_2d,'IXTdataset_2d');

% check for empty fields and replace if necessary
for i = 1:length(varargin) 
    if ischar(varargin{i}) && isempty(varargin{i})
        varargin{i} = ' ';
    end
end

if(nargin == 2) && iscellnum(varargin)
    dataset_2d = libisisexc('IXTdataset_2d','createxyze',dataset_2d,varargin{1},varargin{2},...
        zeros(length(varargin{1}),length(varargin{2})),zeros(length(varargin{1}),length(varargin{2})));
elseif(nargin == 3) && iscellnum(varargin)
    dataset_2d = libisisexc('IXTdataset_2d','createxyze',dataset_2d,varargin{1},varargin{2},varargin{3},zeros(size(varargin{3})));
elseif (nargin == 4) && iscellnum(varargin)
    dataset_2d = libisisexc('IXTdataset_2d','createxyze',dataset_2d,varargin{1},varargin{2},varargin{3}, varargin{4});
elseif (nargin > 0)           
    dataset_2d = libisisexc('IXTdataset_2d','create',dataset_2d,varargin);
end

