function dataset_1d = IXTdataset_1d( varargin )
%  IXTdataset_1d(IXTbase, 'title', [signal], [error], IXTaxis, [x], IXTaxis, [x_distribution])
%
%  Creates an IXTdataset_1d object with the following elements:
%
%   IXTbase            IXTbase 
% 	title				char			Title of dataset for plotting purposes
% 	signal					real    		Signal
% 	error					real    		Standard error
% 	s_axis				IXTaxis			S axis object containing caption and units codes
% 	x					real        	values of bin boundaries (if histogram data)
% 						real            values of data point positions (if point data)
% 	x_axis				IXTaxis			X axis object containing caption and units codes
% 	x_distribution      logical         distribution data flag
% 
dataset_1d.base = IXTbase;
dataset_1d.title=[' '];
dataset_1d.signal=0;
dataset_1d.error=0;
dataset_1d.s_axis = IXTaxis;
dataset_1d.x=0;
dataset_1d.x_axis = IXTaxis;
dataset_1d.x_distribution=false;
dataset_1d = class(dataset_1d,'IXTdataset_1d');


% check for empty fields and replace if necessary
for i = 1:length(varargin) 
    if ischar(varargin{i}) && isempty(varargin{i})
        varargin{i} = ' ';
    end
end

%for a special xye constructor
if(nargin == 1) && iscellnum(varargin)
    dataset_1d = libisisexc('IXTdataset_1d','createxye',dataset_1d,varargin{1},zeros(size(varargin{1})),zeros(size(varargin{1})));
elseif(nargin == 2) && iscellnum(varargin)
    dataset_1d = libisisexc('IXTdataset_1d','createxye',dataset_1d,varargin{1},varargin{2},zeros(size(varargin{2})));
elseif (nargin == 3) && iscellnum(varargin)
    dataset_1d = libisisexc('IXTdataset_1d','createxye',dataset_1d,varargin{1},varargin{2},varargin{3});
elseif (nargin > 0)
    dataset_1d = libisisexc('IXTdataset_1d','create',dataset_1d,varargin);
end
