function axis = IXTaxis(varargin)
% IXTaxis(IXTbase,'caption','units','code')
% creates an IXTaxis object 
% caption can be multiline in the form of a cell array or a character array
axis.base = IXTbase;
axis.caption = [ 'line1'; 'line2' ];
axis.units = ' ';
axis.code = ' ';
axis = class(axis,'IXTaxis');
% now call the fortran constructor which will fill the object
% and also check its arguments

if (nargin == 1) 
    if ischar(varargin{1})
        if (varargin{1}(1)=='$')   
            axis = libisisexc('IXTaxis','create_code_varargin',axis,varargin);    
        else
            axis = libisisexc('IXTaxis','create_caption_varargin',axis,varargin);    
        end
    end
    if iscellstr(varargin{1})
        caption=char(varargin{1});        
        axis = libisisexc('IXTaxis','create_caption',axis,caption);
    end
elseif (nargin == 2)
    if iscellstr(varargin{1})
        caption=char(varargin{1});
    else
        caption=varargin{1};
    end 
    axis = libisisexc('IXTaxis','create_caption_units',axis,caption,varargin{2});
elseif (nargin == 3)
    if iscellstr(varargin{1})
        caption=char(varargin{1});
    else
        caption=varargin{1};
    end 
    axis = libisisexc('IXTaxis','create_caption_units_code',axis,caption,varargin{2},varargin{3});
elseif (nargin > 0) 
    axis = libisisexc('IXTaxis','create',axis,varargin);
end